import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
  * GUI fr das Wrfelspiel dice
  * Zwei Spieler knnen einen Betrag setzen und dann abwechselnd wrfeln.
  * Wrfelt einer der Spieler einen Gewinnwurf gewinnt er, der andere verliert.
  * Bei einem Verlustwurf ist es umgekehrt.
  *
  * @version 1.0 vom 08.10.2012
  * @author Thomas Schaller  und Thomas Ningelgen
  */

public class DiceGUI extends JFrame {
  // Anfang Attribute
  private Spieler sp1;       // Zwei Spieler verwalten
  private Spieler sp2;
  
  private WuerfelPanel wuerfelPanel1;
  private JPanel jPSpieler1 = new JPanel(null, true);
    private JLabel jLabel4 = new JLabel();
    private JNumberField jNFSpieler1Punkte = new JNumberField();
    private JLabel jLabel5 = new JLabel();
    private JNumberField jNFSpieler1NeuEinsatz = new JNumberField();
  private JLabel jLabel1 = new JLabel();
  private JLabel jLabel2 = new JLabel();
  private JNumberField jNFSpieler1Guthaben = new JNumberField();
  private JLabel jLabel3 = new JLabel();
  private JNumberField jNFSpieler1GesEinsatz = new JNumberField();
  private JButton jBSpieler1Setzen = new JButton();
  private JPanel jPSpieler2 = new JPanel(null, true);
    private JLabel jLabel41 = new JLabel();
    private JNumberField jNFSpieler2Punkte = new JNumberField();
    private JNumberField jNFSpieler2NeuEinsatz = new JNumberField();
    private JLabel jLabel6 = new JLabel();
  private JLabel jLabel21 = new JLabel();
  private JNumberField jNFSpieler2Guthaben = new JNumberField();
  private JLabel jLabel31 = new JLabel();
  private JNumberField jNFSpieler2GesEinsatz = new JNumberField();
  private JButton jBSpieler2Setzen = new JButton();
  private JLabel jLabel11 = new JLabel();
  private JLabel jLMeldung = new JLabel();
  private Dice dice;
  private JButton jBWuerfeln = new JButton();
  private JRadioButton jRBWuerfel1 = new JRadioButton();
  private JRadioButton jRBWuerfel2 = new JRadioButton();
  private JRadioButton jRBWuerfel3 = new JRadioButton();
  private JRadioButton jRBWuerfel4 = new JRadioButton();
  private JRadioButton jRBWuerfel5 = new JRadioButton();
  private JLabel jLMeldung1 = new JLabel();
  // Ende Attribute
  
  public DiceGUI(String title) {
    // Frame-Initialisierung
    super(title);
    setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    int frameWidth = 795; 
    int frameHeight = 317;
    setSize(frameWidth, frameHeight);
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    int x = (d.width - getSize().width) / 2;
    int y = (d.height - getSize().height) / 2;
    setLocation(x, y);
    setResizable(false);
    Container cp = getContentPane();
    cp.setLayout(null);
    // Anfang Komponenten
    
    jPSpieler1.setBounds(8, 8, 169, 217);
    jPSpieler1.setOpaque(true);
    
    
    cp.add(jPSpieler1);
    jLabel1.setBounds(0, 8, 110, 20);
    jLabel1.setText("Spieler 1");
    jPSpieler1.add(jLabel1);
    jLabel2.setBounds(0, 40, 70, 20);
    jNFSpieler1Guthaben.setBounds(94, 40, 75, 20);
    jLabel3.setBounds(0, 72, 89, 20);
    jNFSpieler1GesEinsatz.setBounds(94, 72, 75, 20);
    jBSpieler1Setzen.setBounds(88, 176, 75, 25);
    jLabel2.setText("Guthaben");
    jPSpieler1.add(jLabel2);
    jNFSpieler1Guthaben.setText("");
    jNFSpieler1Guthaben.setEditable(false);
    jPSpieler1.add(jNFSpieler1Guthaben);
    jLabel3.setText("Gesamteinsatz");
    jPSpieler1.add(jLabel3);
    jNFSpieler1GesEinsatz.setText("");
    jNFSpieler1GesEinsatz.setEditable(false);
    jPSpieler1.add(jNFSpieler1GesEinsatz);
    jBSpieler1Setzen.setText("setzen");
    jBSpieler1Setzen.setMargin(new Insets(2, 2, 2, 2));
    jBSpieler1Setzen.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        jBSpieler1Setzen_ActionPerformed(evt);
      }
    });
    jPSpieler1.add(jBSpieler1Setzen);
    jPSpieler2.setBounds(592, 8, 185, 217);
    jPSpieler2.setOpaque(true);
    cp.add(jPSpieler2);
    jLabel21.setBounds(8, 40, 70, 20);
    jNFSpieler2Guthaben.setBounds(96, 40, 75, 20);
    jLabel31.setBounds(8, 72, 89, 20);
    jNFSpieler2GesEinsatz.setBounds(96, 72, 75, 20);
    jBSpieler2Setzen.setBounds(96, 176, 75, 25);
    jLabel21.setText("Guthaben");
    jPSpieler2.add(jLabel21);
    jNFSpieler2Guthaben.setText("");
    jNFSpieler2Guthaben.setEditable(false);
    jPSpieler2.add(jNFSpieler2Guthaben);
    jLabel31.setText("Gesamteinsatz");
    jPSpieler2.add(jLabel31);
    jNFSpieler2GesEinsatz.setText("");
    jNFSpieler2GesEinsatz.setEditable(false);
    jPSpieler2.add(jNFSpieler2GesEinsatz);
    jBSpieler2Setzen.setText("setzen");
    jBSpieler2Setzen.setMargin(new Insets(2, 2, 2, 2));
    jBSpieler2Setzen.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        jBSpieler2Setzen_ActionPerformed(evt);
      }
    });
    jPSpieler2.add(jBSpieler2Setzen);
    jLabel11.setBounds(8, 8, 110, 20);
    jLabel11.setText("Spieler 2");
    jPSpieler2.add(jLabel11);
    jLMeldung.setBounds(200, 216, 406, 28);
    jLMeldung.setText("Bitte machen Sie Ihren Pflichteinsatz");
    jLMeldung.setHorizontalTextPosition(SwingConstants.CENTER);
    jLMeldung.setHorizontalAlignment(SwingConstants.CENTER);
    cp.add(jLMeldung);
    jBWuerfeln.setBounds(352, 184, 75, 25);
    jBWuerfeln.setText("wrfeln");
    jBWuerfeln.setMargin(new Insets(2, 2, 2, 2));
    jBWuerfeln.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        jBWuerfeln_ActionPerformed(evt);
      }
    });
    cp.add(jBWuerfeln);
    jRBWuerfel1.setBounds(240, 144, 20, 20);
    jRBWuerfel1.setText("");
    jRBWuerfel1.setOpaque(false);
    cp.add(jRBWuerfel1);
    jRBWuerfel2.setBounds(300, 144, 20, 20);
    jRBWuerfel2.setText("");
    jRBWuerfel2.setOpaque(false);
    cp.add(jRBWuerfel2);
    jRBWuerfel3.setBounds(360, 144, 23, 17);
    jRBWuerfel3.setText("");
    jRBWuerfel3.setOpaque(false);
    cp.add(jRBWuerfel3);
    jRBWuerfel4.setBounds(420, 144, 20, 20);
    jRBWuerfel4.setText("");
    jRBWuerfel4.setOpaque(false);
    cp.add(jRBWuerfel4);
    jRBWuerfel5.setBounds(480, 144, 20, 20);
    jRBWuerfel5.setText("");
    jRBWuerfel5.setOpaque(false);
    cp.add(jRBWuerfel5);
    jLabel4.setBounds(0, 136, 70, 20);
    jLabel4.setText("Punkte");
    jPSpieler1.add(jLabel4);
    jNFSpieler1Punkte.setBounds(94, 136, 75, 20);
    jNFSpieler1Punkte.setText("");
    jNFSpieler1Punkte.setEnabled(true);
    jNFSpieler1Punkte.setEditable(false);
    jPSpieler1.add(jNFSpieler1Punkte);
    jLabel41.setBounds(8, 136, 70, 20);
    jLabel41.setText("Punkte");
    jPSpieler2.add(jLabel41);
    jNFSpieler2Punkte.setBounds(96, 136, 75, 20);
    jNFSpieler2Punkte.setText("");
    jNFSpieler2Punkte.setEditable(false);
    jPSpieler2.add(jNFSpieler2Punkte);
    jLabel5.setBounds(0, 104, 81, 20);
    jLabel5.setText("neuer Einsatz");
    jPSpieler1.add(jLabel5);
    jNFSpieler1NeuEinsatz.setBounds(94, 104, 75, 20);
    jNFSpieler1NeuEinsatz.setText("1");
    jNFSpieler1NeuEinsatz.setEditable(false);
    jPSpieler1.add(jNFSpieler1NeuEinsatz);
    jNFSpieler2NeuEinsatz.setBounds(96, 104, 75, 20);
    jNFSpieler2NeuEinsatz.setText("1");
    jNFSpieler2NeuEinsatz.setEditable(false);
    jPSpieler2.add(jNFSpieler2NeuEinsatz);
    jLabel6.setBounds(8, 104, 81, 20);
    jLabel6.setText("neuer Einsatz");
    jPSpieler2.add(jLabel6);
    jLMeldung1.setBounds(8, 248, 774, 28);
    jLMeldung1.setText("");
    jLMeldung1.setHorizontalAlignment(SwingConstants.CENTER);
    jLMeldung1.setHorizontalTextPosition(SwingConstants.CENTER);
    cp.add(jLMeldung1);
    // Ende Komponenten
    
    // Dice Grundaufbau erzeugen (z.B. auch Wrfel)
    dice = new Dice();
    
    wuerfelPanel1= new WuerfelPanel(dice.getWuerfel(0),dice.getWuerfel(1),dice.getWuerfel(2),dice.getWuerfel(3),dice.getWuerfel(4));
    wuerfelPanel1.setBounds(184, 8, 401, 129);
    
    cp.add(wuerfelPanel1);
    
    // Zwei Spieler mit Startguthaben von 100 erzeugen
    sp1 = new Spieler(100);
    sp2 = new Spieler(100);
    
    // Spieler bei der Spielleitung anmelden
    dice.setSpieler(sp1);
    dice.setSpieler(sp2);
    
    // Informationen ber Spieler anzeigen
    showSpieler();
    setVisible(true);
    
  } // end of public DiceGUI
  
  // Anfang Methoden
  /** Informationen ber die Spieler werden angezeigt. Es werden das Guthaben angezeigt
  * und je nach dem, welche Spieler an der Reihe ist, der Hintergrund dunkler eingefrbt.
  * Auerdem wird angezeigt, welcher Spieler dran ist.
  */
  
  public void showSpieler() {
    jBWuerfeln.setEnabled(false);
    // Guthaben, Gesamtguthaben und Punkte anzeigen
    jNFSpieler1Guthaben.setInt(sp1.getGuthaben());
    jNFSpieler1GesEinsatz.setInt(sp1.gesamtEinsatz);
    jNFSpieler2Guthaben.setInt(sp2.getGuthaben());
    jNFSpieler2GesEinsatz.setInt(sp2.gesamtEinsatz);
    jNFSpieler1Punkte.setInt(sp1.punkte);
    jNFSpieler2Punkte.setInt(sp2.punkte);   
    // Wenn das Spieler luft (beide Spieler haben gesetzt), aktuelle Meldungen anzeigen
    if (sp1.hatGesetzt && sp2.hatGesetzt) {
      if (sp1.gesamtEinsatz != sp2.gesamtEinsatz) {
        jBWuerfeln.setText("abrechnen");
        jLMeldung.setText("Bitte Spiel abrechnen");
        jLMeldung1.setText("");
      } // end of if
      else {
        if (dice.getSpielerAmZug()==sp1) {
          jLMeldung.setText("Spieler 1 bitte wrfeln.");
          jLMeldung1.setText("");
          if (dice.getSpielerAmZug().wurfNummer > 0) {
            jLMeldung1.setText("Klicken Sie zuvor die Wrfel an, die Sie liegen lassen wollen!");
          } // end of if
        } else {
          jLMeldung.setText("Spieler 2 bitte wrfeln.");
          jLMeldung1.setText("");
          if (dice.getSpielerAmZug().wurfNummer > 0) {
            jLMeldung1.setText("Klicken zuvor Sie die Wrfel an, die Sie liegen lassen wollen!");
          } // end of if
        }// end of else  
      } // end of else
      
      jBWuerfeln.setEnabled(true);
    }
  }
  
  
  /** Aktion: Geld setzen von Spieler 1.
  * Betrag wird gesetzt 
  */
  public void jBSpieler1Setzen_ActionPerformed(ActionEvent evt) {
    sp1.setze(jNFSpieler1NeuEinsatz.getInt());
    sp1.hatGesetzt = true;
    jNFSpieler1NeuEinsatz.setInt(0);
    jBSpieler1Setzen.setEnabled(false);
    jNFSpieler1NeuEinsatz.setEditable(true);
    showSpieler();
  } // end of jBSpieler1Setzen_ActionPerformed
  
  /** Aktion: Geld setzen von Spieler 2.
  * Betrag wird gesetzt 
  */
  public void jBSpieler2Setzen_ActionPerformed(ActionEvent evt) {
    sp2.setze(jNFSpieler2NeuEinsatz.getInt());
    sp2.hatGesetzt = true;
    jNFSpieler2NeuEinsatz.setInt(0);
    jBSpieler2Setzen.setEnabled(false);
    jNFSpieler2NeuEinsatz.setEditable(true);
    showSpieler();
  } // end of jBSpieler2Setzen_ActionPerformed
  
  public void jBWuerfeln_ActionPerformed(ActionEvent evt) {
    if (jBWuerfeln.getText()== "abrechnen") {
      jBWuerfeln.setText("wrfeln");
      
      dice.auswerten();
      neueRundeNachAusstieg();
    } else {
      jBSpieler1Setzen.setEnabled(true);
      jBSpieler2Setzen.setEnabled(true);
      if (dice.getSpielerAmZug() == sp1) {         // Spieler 1 ist dran
        if (sp1.wurfNummer < 3) {
          if (jRBWuerfel1.isSelected()) {sp1.mitWuerfel[0] = false; }   else {sp1.mitWuerfel[0] = true;}
          if (jRBWuerfel2.isSelected()) {sp1.mitWuerfel[1] = false; }   else {sp1.mitWuerfel[1] = true;}
          if (jRBWuerfel3.isSelected()) {sp1.mitWuerfel[2] = false; }   else {sp1.mitWuerfel[2] = true;}
          if (jRBWuerfel4.isSelected()) {sp1.mitWuerfel[3] = false; }   else {sp1.mitWuerfel[3] = true;}
          if (jRBWuerfel5.isSelected()) {sp1.mitWuerfel[4] = false; }   else {sp1.mitWuerfel[4] = true;}
          sp1.wuerfelnMit(sp1.mitWuerfel);
          wuerfelPanel1.repaint();
          sp1.hatGesetzt = false; sp2.hatGesetzt = false;
          dice.auswerten();
          showSpieler();
          jBWuerfeln.setEnabled(false);        
          jLMeldung.setText("Bitte Spieler 1 erneut einen Betrag zwischen 0 und 3 setzten!");
          jLMeldung1.setText("Wenn Spieler 2 nicht mit dem gleichen Betrag mitgeht, hat er verloren!");
          if (sp1.wurfNummer == 3) {   //letzter Wurf von Spieler 1  ist durchgefhrt
            jLMeldung.setText("Der zweite Spieler ist jetzt dran");
            jLMeldung1.setText("Spieler 2 setzt zuerst. Wenn Spieler 1 nicht mitgeht, hat er verloren!");
            sp1.hatGesetzt = false; sp2.hatGesetzt = false;
            dice.amZug = (dice.amZug+1)%2;
            jBWuerfeln.setEnabled(false);
            alleRButAbwaehlen();
          } // end of if       
        }
        
      } // end of if
      else {                                       // Spieler 2 ist dran
        if (sp2.wurfNummer < 3) {
          
          if (jRBWuerfel1.isSelected()) {sp2.mitWuerfel[0] = false; }   else {sp2.mitWuerfel[0] = true;}
          if (jRBWuerfel2.isSelected()) {sp2.mitWuerfel[1] = false; }   else {sp2.mitWuerfel[1] = true;}
          if (jRBWuerfel3.isSelected()) {sp2.mitWuerfel[2] = false; }   else {sp2.mitWuerfel[2] = true;}
          if (jRBWuerfel4.isSelected()) {sp2.mitWuerfel[3] = false; }   else {sp2.mitWuerfel[3] = true;}
          if (jRBWuerfel5.isSelected()) {sp2.mitWuerfel[4] = false; }   else {sp2.mitWuerfel[4] = true;}
          sp2.wuerfelnMit(sp2.mitWuerfel);
          wuerfelPanel1.repaint();
          sp1.hatGesetzt = false; sp2.hatGesetzt = false;
          dice.auswerten();       
          showSpieler();
          jBWuerfeln.setEnabled(false);
          jLMeldung.setText("Bitte Spieler 2 erneut einen Betrag zwischen 0 und 3 setzten!");
          jLMeldung1.setText("Wenn Spieler 1 nicht mit dem gleichen Betrag mitgeht, hat er verloren!");
        }  
        if (sp2.wurfNummer == 3) {
          jLMeldung.setText("Gewinn und Verlust wurden mit den jeweiligen Guthaben verrechnet");
          jLMeldung1.setText("Fr eine neue Runde: Zuerst Spieler 1 dann Spieler 2 setzen!");
          dice.gewinnFeststellen();
          alleRButAbwaehlen();
          dice.amZug = (dice.amZug+1)%2;
          neueRunde();
        } // end of if         
      } // end of else
      
    } // end of if-else
    
  } // end of jBWuerfeln_ActionPerformed
  
  public void neueRunde() {
    jNFSpieler1Guthaben.setInt(sp1.getGuthaben());
    jNFSpieler2Guthaben.setInt(sp2.getGuthaben());
    jNFSpieler1GesEinsatz.setInt(0); jNFSpieler1Punkte.setInt(0);
    jNFSpieler2GesEinsatz.setInt(0); jNFSpieler2Punkte.setInt(0);
    jBWuerfeln.setEnabled(false);
    jNFSpieler1NeuEinsatz.setInt(1); jNFSpieler1NeuEinsatz.setEditable(false);
    jNFSpieler2NeuEinsatz.setInt(1); jNFSpieler2NeuEinsatz.setEditable(false); 
    sp1.hatGesetzt = false; sp2.hatGesetzt = false;
    alleRButAbwaehlen();
    sp1.wurfNummer = 0;  sp2.wurfNummer = 0; 
  }
  
  public void alleRButAbwaehlen() {
    jRBWuerfel1.setSelected(false);jRBWuerfel2.setSelected(false);
    jRBWuerfel3.setSelected(false);jRBWuerfel4.setSelected(false);
    jRBWuerfel5.setSelected(false);
  }
  
  
  public void neueRundeNachAusstieg() {
    jLMeldung.setText("Gewinn und Verlust wurden mit den jeweiligen Guthaben verrechnet");
    jLMeldung1.setText("Fr eine neue Runde: Zuerst Spieler 1 dann Spieler 2 setzen!");    
    jBSpieler1Setzen.setEnabled(true); jBSpieler2Setzen.setEnabled(true);
    dice.amZug = 0;
    neueRunde();
  }
  
  // Ende Methoden
  
  public static void main(String[] args) {
    new DiceGUI("DiceGUI");
  }
  
  
} // end of class diceGUI
