/**
  * Die Klasse Spieler speichert die Daten eines Spielers fr das Spiel Dice.
  *
  * @version 1.0 vom 08.10.2012
  * @author Thomas Schaller 
  */
  
public class Spieler {
  // Anfang Attribute
  protected int guthaben; // Guthaben des Spielers
  protected int einsatz = 0; // Betrag den der Spieler gesetzt hat
  protected int gesamtEinsatz = 0; //Die addierten Einsetze pro Runde
  private Dice spielleiter; // Referenz auf Spielleitung
  protected boolean[] mitWuerfel = new boolean[5];
  protected int punkte;
  protected int wurfNummer = 0;   //zhlt die Wrfe eines Spielers: maximal 3 
  protected boolean hatGesetzt = false;
  // Ende Attribute
  
  /** Erzeugt einen Spieler mit einem bestimmten Startguthaben.
  * @param guthaben Startguthaben des Spielers
  */
  public Spieler(int guthaben) {
    this.guthaben = guthaben;
    this.einsatz = 0;
    this.spielleiter = null;
  }
  
  // Anfang Methoden
  /** Referenz auf Spielleiter setzen.
  */
  public void setSpielleiter(Dice spielleiter) {
    this.spielleiter = spielleiter;
  }
  
  /** Liefert das aktuelle Guthaben des Spielers.
  * @return Guthaben des Spielers
  */
  public int getGuthaben() {
    return guthaben;
  }
  
  /** Setzt den Einsatz fr das nchste Spiel.
  * @param betrag eingesetzter Betrag
  */
  public void setze(int betrag) {
    gesamtEinsatz += betrag;
    einsatz += betrag;
    guthaben -= betrag;
    
  }
  
  /** Rechnet den Gewinn des Spielers ab, da er gewonnen hat.
  */
  public void gewonnen() {
    guthaben += (2 * gesamtEinsatz);
    einsatz = 0; gesamtEinsatz = 0;
  }
  
  /** Da der Spieler verloren hat, ist der Einsatz verloren.
  */
  public void verloren() {
    einsatz = 0; gesamtEinsatz = 0;
  }
  //Spieler wrfelt nur mit den Wrfeln bei denen mitWuerfel[i] wahr ist.
  public void wuerfelnMit(boolean[] mitWuerfel) {
    if (spielleiter.getSpielerAmZug() == this) {
      for (int i = 0;i<5 ;i++ ) {
        if (mitWuerfel[i]) {spielleiter.getWuerfel(i).wuerfeln();} 
      } // end of for
    } // end of if 
  }
  
  // Ende Methoden
} // end of Spieler
