import javax.swing.JPanel;
import java.awt.*;

/**
  * Hilfsklasse zum Anzeigen zweier Wrfel fr Wrfelspiele.
  * Je nach Augenzahl der letzten Wrfelergebnisse werden die Bilder wuerfel_1.gif - wuerfel_6.gif angezeigt.
  *
  * @version 1.0 vom 05.10.2012
  * @author Thomas Schaller 
  */


public class WuerfelPanel extends JPanel {

  // Anfang Attribute
  private Image[] bilder = new Image[6];  // Referenz auf die Wrfelbilder wuerfel_x.gif
  private Wuerfel wuerfel1, wuerfel2, wuerfel3, wuerfel4, wuerfel5;     // Referenz auf die anzuzeigenden Wrfel
  // Ende Attribute
  
  /** Erzeugt ein Anzeigepanel fr fnf Wrfel.
  * @param w1 1. Wrfel
  * @param w2 2. Wrfel etc
  */
  public WuerfelPanel(Wuerfel w1, Wuerfel w2,Wuerfel w3, Wuerfel w4, Wuerfel w5) {;
    this.wuerfel1 = w1;
    this.wuerfel2 = w2;
    this.wuerfel3 = w3;
    this.wuerfel4 = w4;
    this.wuerfel5 = w5;
    // Bilder laden
    for (int i = 0; i <6  ; i++ ) {
      bilder[i] = Toolkit.getDefaultToolkit().getImage("wuerfel_"+(i+1)+".gif");
    } // end of for
    this.setBackground(Color.white);
  }
  
  /** Zeichnet das Panel. Angezeigt werden die Bilder fr die zwei Augenzahlen der beiden Wrfel.
  * Diese Methode wird automatisch von Java aufgerufen.
  * @param g Grafikkontext auf dem gezeichnet werden soll.
  */
  public void paint(Graphics g) {
    super.paint(g);
    g.drawImage(bilder[wuerfel1.getWurf()-1],45,40,Color.white,this);
    g.drawImage(bilder[wuerfel2.getWurf()-1],105,40,Color.white,this);
    g.drawImage(bilder[wuerfel3.getWurf()-1],165,40,Color.white,this);
    g.drawImage(bilder[wuerfel4.getWurf()-1],225,40,Color.white,this);
    g.drawImage(bilder[wuerfel5.getWurf()-1],285,40,Color.white,this);
    
  }
  
} // end of Board