import java.util.ArrayList;

/**
  * Spielleiter fr das Wrfelspiel Craps .
  * Es werden die Mitspieler verwaltet, der aktuelle Spieler gespeichert, die Wrfel erzeugt.
  * Es knnen bis zu 6 Spieler am Spiel teilnehmen
  *
  * @version 1.0 vom 20.06.2012
  * @author Thomas Schaller
  */

public class Spielleitung {

  // Anfang Attribute
  private ArrayList<Spieler> spieler;
  private Wuerfel wuerfel0;
  private Wuerfel wuerfel1;
  private int point=0;                            // aktueller Point, d.h. die zuerst geworfene Zahl im Durchgang
  // Ende Attribute
  
  /** Erzeugt den Spielleiter fr Craps. Es werden auch die notwendigen zwei Wrfel erzeugt.
  */
  public Spielleitung() {;
    // erzeugt 2 Wrfel
    this.wuerfel0 = new Wuerfel();
    this.wuerfel1 = new Wuerfel();
    this.spieler  = new ArrayList<Spieler>();
  }
  
  // Anfang Methoden
  /** Meldet einen Spieler beim Spielleiter an. Der Spieler wird darber informiert, wer der Spielleiter ist.
  * @param s Spieler, der angemeldet werden soll.
  */
  public void addSpieler(Spieler s) {
    spieler.add(s);
    if (spieler.size()==1) {  // Der erste angemeldete Spieler wird automatisch zum Shooter
      s.setShooter(true);
    } else {
      s.setShooter(false);
    }// end of if
  }
  
  
  /** Testet, ob die aktuelle Wrfelkombination ein Gewinnwurf ist.
  * @return true, wenn es sich um einen Gewinnwurf handelt, sonst false.
  */
  public boolean gewinnwurf () {
    // erster Wurf: Natural
    if (wuerfel0.getWurf()+wuerfel1.getWurf()==7 && point == 0) return true;
    if (wuerfel0.getWurf()+wuerfel1.getWurf()==11 && point == 0) return true;
    // weitere Wrfe:
    if (wuerfel0.getWurf()+wuerfel1.getWurf()==point) return true;
    return false;
  }
  
  /** Testet, ob die aktuelle Wrfelkombination ein Verlustwurf ist.
  * @return true, wenn es sich um einen Verlustwurf handelt, sonst false.
  */
  public boolean verlustwurf () {
    // erster Wurf: Crap
    if (wuerfel0.getWurf()+wuerfel1.getWurf()==2 && point == 0) return true;
    if (wuerfel0.getWurf()+wuerfel1.getWurf()==3 && point == 0) return true;
    if (wuerfel0.getWurf()+wuerfel1.getWurf()==12 && point == 0) return true;
    // weitere Wrfe: 7 aus dem Spiel
    if (wuerfel0.getWurf()+wuerfel1.getWurf()==7 && point != 0) return true;
    return false;
  }
  
  /** Wertet den letzten Wrfelwurf aus. Falls es ein Gewinn- oder Verlustwurf ist,
  * werden die Spieler ber ihren Sieg / Verlust informiert.
  * @return true, wenn es sich um einen Gewinn- oder Verlustwurf handelt und ein neuer Durchgang beginnen muss, sonst false.
  */
  public boolean auswerten() {
    if (gewinnwurf()) {
      for (Spieler s : spieler ) {
        if (s.getShooter()) {   // Alle Spieler haben verloren, nur Shooter gewonnen
          s.gewonnen();
        } else {
          s.verloren();
        }// end of if
      } // end of for
      return true;
    } // end of if
    if (verlustwurf()) {
      for (Spieler s : spieler ) {
        if (s.getShooter()) {  // Alle Spieler haben gewonnen, nur Shooter verloren
          s.verloren();
        } else {
          s.gewonnen();
        }// end of if
      } // end of for
      return true;
    } // end of if
    // Beim ersten Wurf ist Point noch 0, daher das Ergebnis des ersten Wurfs als Point merken
    if (point == 0) {
      point = wuerfel0.getWurf()+wuerfel1.getWurf();
    } // end of if
    return false;
  }
  
  /** Neuen Durchgang starten. Der Point wird zurckgesetzt und der nchste Spieler wird Shooter,
  falls der Shooter den vorherigen Durchgang verloren hat.
  */
  public void neuesSpiel() {
    if (verlustwurf()) {
      for (Spieler s: spieler) {
        if (s.getShooter()) {
          s.setShooter(false);
          spieler.get((spieler.indexOf(s)+1)%spieler.size()).setShooter(true);      // Der nchste Spieler (index+1) wird zu Shooter. Wenn der letzte Spieler shooter war muss es der erste werden, daher modulo Anzahl der Spieler
          break;
        } // end of if
      } // end of for
      
    } // end of if
    
    point = 0;
  }
  
  /** liefert eine Referenz auf einen Wrfel
  * @param nr Nummer des gewnschten Wrfels
  * @return Referenz auf den Wrfel
  */
  public Wuerfel getWuerfel(int nr) {
    if (nr==0) {
      return wuerfel0;
    } else {
      return wuerfel1;
    } // end of if
  }
  
  /** liefert eine Referenz auf einen Spieler.
  * @param nr Nummer des Spielers.
  * @return Referenz auf Spieler mit Nummer nr.
  */
  public Spieler getSpieler(int nr) {
    return spieler.get(nr);
  }
  
  // Ende Methoden
} // end of Barbudi
