/**
  * Speichert die Informationen ber eine Gerade im Raum. Dazu werden
  * Sttz- und Richtungsvektor der Geraden gespeichert. Fr die Berechnung eines
  * 3D-Bildes kann auerdem der Schnittpunkt mit der XY-Ebene(=Bildschirmebene) berechnet werden.
  *
  * @version 1.0 vom 10.04.2011
  * @author T. Schaller
  */

public class Gerade {

  // Anfang Attribute
  private Punkt stuetzpunkt;        // Sttzpunkt der Geraden
  private Vektor richtungsvektor;   // Richtungsvektor der Geraden
  // Ende Attribute
  
  /** Erzeugt eine Gerade aus zwei Punkten. Punkt1 wird als Sttzpunkt, der Vektor von P1 nach P2 als Richtungsvektor benutzt.
   * @param p1 1. Punkt der Gerade
   * @param p2 2. Punkt der Gerade
   */
  public Gerade(Punkt p1, Punkt p2) {;
    stuetzpunkt = p1;
    richtungsvektor = new Vektor(p2.getX()-p1.getX(),p2.getY()-p1.getY(),p2.getZ()-p1.getZ());
  }
  
  // Anfang Methoden
  /** Liefert den Richtungsvektor der Gerade
  * @return Richtungsvektor
  */
  public Vektor getRichtungsvektor() {
    return richtungsvektor;
  }
  
  
  /** Liefert den Sttzpunkt der Gerade
  * @return Sttzpunkt
  */
  public Punkt getStuetzpunkt() {
    return stuetzpunkt;
  }
  
  /** Liefert den Schnittpunkt der Gerade mit der XY-Ebene (d.h. z-Koordinate = 0)
  * Die Gerade, die bei der Berechnung vorkommen knnen nicht in der XY-Ebene liegen, da
  * der Augenpunkt immer ein Punkt der Gerade ist und auerhalb der Ebene liegt.
  * @return Schnittpunkt mit der XY-Ebene, falls es diesen gibt; sonst null
  */
  public Punkt getSchnittpunktXYEbene() {
    if (richtungsvektor.getZ() ==0) {   // Gerade ist parallel zur XY-Ebene
      return null;
    }
    else
    {
      double l = -stuetzpunkt.getZ()/richtungsvektor.getZ();  // Parameterwert fr Gerade bestimmen
      return new Punkt(stuetzpunkt.getX()+l*richtungsvektor.getX(),stuetzpunkt.getY()+l*richtungsvektor.getY(),stuetzpunkt.getZ()+l*richtungsvektor.getZ());
    }
  }

  // Ende Methoden
}
