/**
  * Speichert die Informationen ber eine Punkt im Raum.
  * Die Information ber die Lage des Punktes werden mit Hilfe eines Ortsvektors
  * gespeichert.
  *
  * @version 1.0 vom 11.4.2011
  * @author T. Schaller
  */

public class Punkt {

  // Anfang Attribute
  private Vektor ortsvektor;   // Ortsvektor des Punktes
  // Ende Attribute
  
  /** Erzeugt einen neuen Punkt mit den Koordinaten (x|y|z)
    * @param x x-Koordinate
    * @param y y-Koordinate
    * @param z z-Koordinate
  */
  Punkt(double x, double y, double z) {
    ortsvektor = new Vektor(x,y,z);
  }
  
  // Anfang Methoden
  /** liefert die x-Koordinate des Ortsvektors des Punktes
  * @return x-Koordinate
  */
  public double getX() {
    return ortsvektor.getX();
  }
  
  /** liefert die y-Koordinate des Ortsvektors des Punktes
  * @return y-Koordinate
  */
  public double getY() {
    return ortsvektor.getY();
  }

  /** liefert die z-Koordinate des Ortsvektors des Punktes
  * @return z-Koordinate
  */
  public double getZ() {
    return ortsvektor.getZ();
  }
  
  /** Verschiebt den Punkt um einen Vektor v. Dazu werden die Koordinaten
  * des Ortsvektors zu den Koordinaten des Schiebevektors addiert.
  * @param v Verschiebevektor
  */
  public void verschiebe(Vektor v) {
    ortsvektor.add(v);
  }
  // Ende Methoden
}
