import java.awt.*;
import java.util.*;

/**
  * Speichert die notwendigen Informationen (Start- und Endpunkt) zu einer
  * Strecke.
  *
  * @version 1.0 vom 10.04.2011
  * @author T. Schaller
  */

public class Strecke {
  
  // Anfang Attribute
  private Punkt point1;  // Referenz auf Start- und Endpunkt
  private Punkt point2;
  // Ende Attribute
  
  /** Erzeugt eine neue Strecken
  * @param p0 Startpunkt
  * @param p1 Endpunkt
  */
  
  public Strecke(Punkt point1, Punkt point2) {
    this.point1 = point1;
    this.point2 = point2;
  }
  
  // Anfang Methoden
  /** Liefert Start- oder Endpunkt der Strecke
  * @param i (1=Startpunkt, 2 = Endpunkt)
  * @return Referenz auf den Punkt
  */
  public Punkt getPunkt(int i) {
    if (i==1) {
      return point1;
    } else {
      return point2;
    } // end of if
  }
  
  
  public void draw(Graphics g, Punkt viewpoint) {
    
    Gerade g1 = new Gerade(viewpoint,point1);                     // Gerade durch Augenpunkt und 1.Punkt der Strecke (Blickstrahl)
    Gerade g2 = new Gerade(viewpoint,point2);                     // Gerade durch Augenpunkt und 2.Punkt der Strecke (Blickstrahl)
    
    Punkt sp1 = g1.getSchnittpunktXYEbene();                     // Schnittpunkte der Blickstrahlen mit der Bildschirmebene (XY-Ebene)
    Punkt sp2 = g2.getSchnittpunktXYEbene();
    
    if ((sp1 != null) && (sp2 != null)) {                         // Falls es Schnittpunkte gibt, Linie zeichnen (Skaliert um Faktor 50)
      g.drawLine((int) ( sp1.getX() * 50) + 450,                  // +450/+350, damit die Szene in der Mitte des Bildschirms gezeichnet wird.
                 (int) (-sp1.getY() * 50) + 350,
                 (int) ( sp2.getX() * 50) + 450,
                 (int) (-sp2.getY() * 50) + 350);
    }
  }
  // Ende Methoden
}
