/*
Dieses Programm soll ein smart-meter in einem Haus modellieren. Dazu empfängt der Arduino die 
Spannung einer Solarzelle am analogen Eingang A0. 
Ist die Spannung kleiner als 1 V gibt es eine Meldung auf dem seriellen Monitor und eine LED am Pin 13 fängt 
an bestimmte Zeit an zu blinken. Alle anderen Geräte werden abgeschaltet.
Ist die Spannung größer 1 V aber kleiner als 2 V, gibt es wieder eine Meldung auf dem seriellen Monitor und die LED am Pin 13 leuchtet
dauerhaft. Alle anderen Geräte sind ausgeschaltet. 
Wird die Spannung gößer als 2 V aber kleiner oder gleich 4 V, gibt eine Meldung auf dem seriellen Monitor. Darin wird 
abgefragt, ob man entweder die Waschmaschine (Elektromotor) starten will oder ob man die Energie im Akku speichern will. 

Taste W oder w startet den Motor, Taste A oder a starte den Akkulader. Die Taste O oder o stoppt den Motor, 
die Taste P oder p stoppt den Akkulader. 

Motor als auch Akku werden über die Solarzelle versorgt. Die Ansteuerung erfolgt über je einen Feldeffekt-Transistor (BUZ11), 
deren Gates über den Pin 12 (Motor) bzw. den Pin 11 (Akku) angesteuert werden. In diesem Fall kann entweder der Motor 
starten oder der Akku geladen werden. 

Ist die Spannung größer als 4 V, gibt es eine Meldung und alle Geräte werden abgeschaltet. 


von Rolf Piffer, September 2016*/


#define ledPin 13
#define motorPin 12
#define akkuPin 11
const int solarPin=0;
const int res1Pin=1;
const int res0Pin=2;

const float untererWert=1;     //unter 1 V kommt Warnsignal
const float grenzeUnten=1.4;  // zwischen 1 und 1,4 V kann man eine LED normal leucten lassen,
                              // aber keinen Motor oder Akku anschließen
const float grenzeOben=4;     // wenn 4 V überschritten werden, sollte weder der Akku geladen
                              // noch der E-Motor betrieben werden

const float referenceVolts = 5.0;  // the default reference on a 5-volt board

char incomingByte;  //Zeichen von der Eingabekonsole
int flagMotor=0;    //Wenn Motor steht
int flagAkku=0;     //wenn Akku nicht geladen wird

void setup() {

  Serial.begin(9600);
  pinMode(ledPin, OUTPUT);
  pinMode(motorPin, OUTPUT);  //Ansteuerung des Gate vom FET 1
  pinMode(akkuPin, OUTPUT);   //Ansteuerung des Gate vom FET 2
}

void loop() {
  
    int value = analogRead(solarPin);  // read the value from the sensor
    float spannung = (value / 1023.0) * referenceVolts;  // calculate the ratio
  
    Serial.flush();
    Serial.print("Spannung = ");
    Serial.println(spannung);

    if (spannung<untererWert)     //Warnhinweis auf seriellen Monitor und LEDE soll blinken
    {
        Serial.println("Achtung: Nur sehr wenig elektrische Energie im Netz.");
        Serial.println("Alle Grossgeraete muessen abgeschaltet werden.");
        Serial.println();
        digitalWrite(motorPin, LOW);    //Motor ausschalten
        digitalWrite(akkuPin, LOW);     //Akkulader ausschalten
        flagAkku=0;
        flagMotor=0;
        
        digitalWrite(ledPin, HIGH);     //LED blinkt mit 1 Hz
        delay(500);
        digitalWrite(ledPin, LOW);
        delay(500);    
    }

    if (spannung>=untererWert && spannung<grenzeUnten)    //Spannung reicht aus, um LED normal leuchten zu lassen
    {
        Serial.println("Es wird wenig elektrische Energie geliefert.");
        Serial.println("Kleinverbraucher koennen aber am Netz bleiben.");
        Serial.println();
        digitalWrite(ledPin, HIGH);
        digitalWrite(motorPin, LOW);
        digitalWrite(akkuPin, LOW);
        flagAkku=0;
        flagMotor=0;
        delay(5000);   
    }
    
    if (spannung>=grenzeUnten && spannung<grenzeOben && (flagAkku==0 || flagMotor==0))
    {
        digitalWrite(ledPin, HIGH);
        Serial.println("Es steht genuegend elektrische Energie zur Verfuegung.");
        
        if (flagAkku==0)
        {
          Serial.println("Wollen Sie einen Akku aufladen, dann geben Sie 'A' ein."); 
        }
        if (flagMotor==0)
        {
          Serial.println("Soll eine Waschmaschine eingeschaltet werden, geben Sie 'W' ein.");
        }
        if (flagMotor==1) 
        {
          Serial.println("Soll die Waschmaschine ausgeschaltet werden, geben Sie 'O' ein.");
        }
        if (flagAkku==1) 
        {
          voltAge();
          Serial.println("Soll der Akkulader ausgeschaltet werden, geben Sie 'P' ein.");    
        }       
        delay(2000);
        if (Serial.available() > 0) {

          Serial.println();
          incomingByte = Serial.read();   //liest das Zeichen von der Eingabe
      
          if ((incomingByte == 'W' || incomingByte == 'w') && flagMotor==0)
          {
            if (flagAkku==1)    //nur wenn Akkulader aktiviert ist
            {
              Serial.println("Akkulader wird ausgeschaltet!");
              digitalWrite(akkuPin, LOW);
              flagAkku=0;
            }
            digitalWrite(motorPin, HIGH);
            Serial.println("Waschmaschine wird eingeschaltet!");
            flagMotor=1;
          } 
          
          if ((incomingByte == 'A' || incomingByte == 'a') && flagAkku==0)
          {
            if (flagMotor==1)       //nur wenn Motor läuft
            {
              Serial.println("Waschmaschine wird ausgeschaltet!");
              digitalWrite(motorPin, LOW);
              flagMotor=0;
            }            
            digitalWrite(akkuPin, HIGH);
            voltAge();  
            flagAkku=1;
          }
          
          if (incomingByte == 'O' || incomingByte == 'o')
          {
            Serial.println("Waschmaschine wird ausgeschaltet!");
            digitalWrite(motorPin, LOW);
            flagMotor=0;
          }  
          
          if (incomingByte == 'P' || incomingByte == 'p')
          {
            digitalWrite(akkuPin, LOW);
            Serial.println("Akkulader wird ausgeschaltet!");
            flagAkku=0;
          }  
       }
       delay(2000);
       Serial.println();
    }
    
    if (spannung>=4)
    {
        Serial.println("Die Netzspannung ist zu hoch.");
        Serial.println("Keine Motoren laufen lassen und keine Akkus aufladen!");
        Serial.println();
        digitalWrite(ledPin, LOW);
        digitalWrite(motorPin, LOW);
        digitalWrite(akkuPin, LOW);
        flagAkku=0;
        flagMotor=0;
        delay(5000);   
    }
}

void voltAge()
{
  int val1 = analogRead(res1Pin);                           // read the voltage-value from the resistor
  float spannung1Akku = (val1 / 1023.0) * referenceVolts;  // Potenzial am Pin 1 des Widerstands
  int val0 = analogRead(res0Pin);                           // read the voltage-value from the resistor
  float spannung0Akku = (val0 / 1023.0) * referenceVolts;  // Potenzial am Pin 0 des Widerstands
  float spannungAkku=spannung1Akku-spannung0Akku;           // Die Potenzialdifferenz (Spannung) 
                                                            // zwischen den beiden Anschluessen
                                                            // des 1-Ohm-Widerstands (1W)
  Serial.println();
  Serial.print("Akku wird geladen. "); 
  Serial.print("Die Ladestromstaerke betraegt: ");      
  Serial.print(spannungAkku);                                 //da R = 1 Ohm ist die Stromstärke = Spannung
  Serial.println(" A");
}
  
  
  

